import cv2

image1 = cv2.imread("baotuquna.png")  # 读取第一幅图像
image2 = cv2.imread("cat.jpg")  # 读取第二幅图像
# 确保两幅图像大小相同
if image1.shape != image2.shape:
    # 使用 cv2.resize 函数将第二幅图像的大小调整为与第一幅图像相同
    image2 = cv2.resize(image2, (image1.shape[1], image1.shape[0]))
# 使用 addWeighted() 方法计算加权和，将两幅图像融合
# 第一种融合效果，第一幅图像的权重为 0.3，第二幅图像的权重为 0.7，标量为 0
blended_image1 = cv2.addWeighted(image1, 0.3, image2, 0.7, 0)
# 第二种融合效果，第一幅图像和第二幅图像的权重均为 0.5，标量为 0
blended_image2 = cv2.addWeighted(image1, 0.5, image2, 0.5, 0)
# 第三种融合效果，第一幅图像的权重为 0.7，第二幅图像的权重为 0.3，标量为 0
blended_image3 = cv2.addWeighted(image1, 0.7, image2, 0.3, 0)
cv2.imshow("Image 1", image1)  # 显示第一幅原始图像
cv2.imshow("Image 2", image2)  # 显示第二幅原始图像
cv2.imshow("Blended Image1", blended_image1)  # 显示第一种融合效果的图像
cv2.imshow("Blended Image2", blended_image2)  # 显示第二种融合效果的图像
cv2.imshow("Blended Image3", blended_image3)  # 显示第三种融合效果的图像
cv2.waitKey(0)  # 等待用户按键并关闭窗口
cv2.destroyAllWindows()