import cv2
import numpy as np

img = cv2.imread("baotuquna.png")  # 读取原始图像
# 创建与原始图像大小相同的掩模
mask = np.zeros(img.shape, dtype=np.uint8)
# 绘制圆形掩模
center = (img.shape[1] // 2, img.shape[0] // 2)  # 圆心位置
radius = 100  # 圆的半径
cv2.circle(mask, center, radius, (255, 255, 255), -1)
img_and = cv2.bitwise_or(img, mask)  # 执行或运算
cv2.imshow("Original Image", img)  # 显示结果
cv2.imshow("Mask", mask)
cv2.imshow("Result of Bitwise OR", img_and)
cv2.waitKey(0)
cv2.destroyAllWindows()