import cv2
import numpy as np

cat = cv2.imread('cat.jpg')  # 读取图⽚
dog = cv2.imread('dog.jpg')
height, width, _ = cat.shape  # 获取第一张图像的尺寸
# 将第二张图像调整为与第一张图像相同的大小
resized_image2 = cv2.resize(dog, (width, height))
# 确保两张图像的数据类型一致
resized_image2 = resized_image2.astype(cat.dtype)
# 使用cv2.add()函数将两张图像相加
result = cv2.add(cat, resized_image2)
# 显示原始图像和结果图像
cv2.imshow('Image 1', cat)
cv2.imshow('Resized Image 2', resized_image2)
cv2.imshow('Result', result)
cv2.waitKey(0)  # 等待按键事件
cv2.destroyAllWindows()  # 关闭所有窗口