import cv2
import numpy as np

# 读取图像
image = cv2.imread('baotuquna.png')
# 获取图像的高度和宽度
height, width = image.shape[:2]
# 创建一个与图像大小相同的掩膜，初始值全为 0（黑色）
mask = np.zeros((height, width), dtype=np.uint8)
# 定义感兴趣区域（ROI），这里以一个矩形区域为例
# 左上角坐标 (x1, y1) 为 (150, 40)，右下角坐标 (x2, y2) 为 (400, 240)
x1, y1 = 150, 40
x2, y2 = 400, 240
mask[y1:y2, x1:x2] = 255  # 将矩形区域的像素值设为 255（白色）
# 反转掩模中的黑白区域
inverted_mask = cv2.bitwise_not(mask)
# 应用反转后的掩膜到图像上
inverted_masked_image = cv2.bitwise_and(image, image, mask=inverted_mask)
# 显示反转后的掩膜和应用反转后掩膜后的图像
cv2.imshow('Inverted Mask', inverted_mask)
cv2.imshow('Inverted Masked Image', inverted_masked_image)
cv2.waitKey(0)  # 等待用户按下任意按键
cv2.destroyAllWindows()  # 关闭所有 OpenCV 窗口