import numpy as np
import cv2

# 创建一个 400x400 的彩色画布，数据类型为 np.uint8
canvas = np.ones((400, 400, 3), np.uint8) * 255
# 绘制横向的两条线段
# 第一条横向线段，颜色为红色，宽度为 5
canvas = cv2.line(canvas, (100, 100), (300, 100), (0, 0, 255), 5)
# 第二条横向线段，颜色为青色，宽度为 10
canvas = cv2.line(canvas, (100, 200), (300, 200), (255, 255, 0), 10)
# 绘制纵向的两条线段
# 第一条纵向线段，颜色为黄色，宽度为 15
canvas = cv2.line(canvas, (150, 50), (150, 300), (0, 255, 255), 15)
# 第二条纵向线段，颜色为紫色，宽度为 20
canvas = cv2.line(canvas, (250, 50), (250, 300), (255, 0, 255), 20)
cv2.imshow("Lines", canvas)  # 显示绘制好的“井”字图像
cv2.waitKey(0)  # 等待用户按下任意键
cv2.destroyAllWindows()  # 关闭所有 OpenCV 窗口