# MainWindow.py
from ui import MainWindowUI as UI
from PyQt5.QtWidgets import QFileDialog,QMainWindow
from PyQt5.QtGui import QPixmap, QImage
import cv2
import numpy as np


class MainWindow(QMainWindow,UI):
    def __init__(self):
        super(MainWindow, self).__init__()
        self.setupUi(self)

        self.btn_load.clicked.connect(self.load_image)# 连接打开槽函数
        self.btn_detect.clicked.connect(self.coinSimpleDetection)# 连接检测硬币槽函数
        self.btn_sum.clicked.connect(self.get_sum)#连接计算总数
 
        
    
    def load_image(self):
        options = QFileDialog.Options()
        fileName, _ = QFileDialog.getOpenFileName(self, "QFileDialog.getOpenFileName()", "", "Image Files (*.png *.jpg *.jpeg)", options=options)
        if fileName:
            self.image = cv2.imread(fileName)
            self.display_image(self.image)
    
    def display_image(self,img):
        if len(img.shape)==3:#彩色图像
            height, width, channel = img.shape
            bytes_per_line = channel * width
            q_img = QImage(img.data, width, height, bytes_per_line, QImage.Format_BGR888)
        else:               # 灰度图像或二值图像
            height, width= img.shape
            bytes_per_line = width
            q_img = QImage(img.data, width, height, bytes_per_line, QImage.Format_Grayscale8)            

        self.label.setPixmap(QPixmap.fromImage(q_img))


    def coinSimpleDetection(self):
        
        minR = int(self.min_edit.text())#30
        maxR = int(self.max_edit.text())#300
        
        img=self.image.copy()
        
        gray_img = cv2.cvtColor(img, cv2.COLOR_BGR2GRAY)                # 三通道转化为灰度图
        gaussian_img = cv2.GaussianBlur(gray_img, (7, 7), 0)            # 使用高斯滤波器降低噪声
        # cv2.imshow('img-1', gaussian_img)                             # 展示高斯滤波后的图片
        Canny_img = cv2.Canny(gaussian_img, 250, 440, apertureSize=3)    # 使用Canny边缘检测器
        # cv2.imshow('img0', Canny_img)                                  # 展示Canny边缘检测器得出的边沿
        circles1 = cv2.HoughCircles(Canny_img, cv2.HOUGH_GRADIENT, 1, 100, param1=400, param2=20,
                                    minRadius=minR, maxRadius=maxR)        # 使用霍夫变换进行边缘连接

        circles = circles1[0, :, :]
        circles = np.uint16(np.around(circles))
        self.circle=circles
        number = 0                                                      # 初始化硬币总数
        
        for i in circles[:]:
            cv2.circle(img, (i[0], i[1]), i[2], (0, 0, 255), 2)
            number = number + 1
        
        text = "The total number of coins is:{} "
        cv2.putText(img, text.format(number), (20, 40), cv2.FONT_HERSHEY_SIMPLEX, 1.0, (100, 200, 200), 2)

        self.display_image(img)  # 更新显示识别后的图像

    def get_sum(self):
        circles=self.circle
        # 简单识别，利用硬币的色彩和半径进行区分
        circlesNum = circles.shape[0]
        print(circlesNum)
        # 将图片裁剪出来
        candidateImage = {}
        for i in range(circlesNum):
            information = {"radius":0,"value":0}
            col,row,radius = circles[i,:]
            imgTemp = self.image.copy()
            imgROI = imgTemp[row-radius:row+radius,col-radius:col+radius,:]
            information["radius"] = radius
    
            # 识别5角硬币
            hsv = cv2.cvtColor(imgROI, cv2.COLOR_BGR2HSV)
            lowerYellowHSV = np.array([11,43,46])
            upperYellowHSV = np.array([34,255,255])
            mask=cv2.inRange(hsv,lowerb=lowerYellowHSV,upperb=upperYellowHSV)/255
            if np.sum(np.array(mask))/((row+2*radius)*(col+2*radius)) > 0.05:
                information["value"] = 0.5
    
            # 根据半径判断1块，新旧1角硬币
            if information["value"] == 0:
                if information["radius"] > 60 and information["radius"] < 85:
                    information["value"] = 0.1
                if information["radius"] > 85 and information["radius"] < 100:
                    information["value"] = 1.0
            candidateImage.update({i:information}) 
        cionsValue = np.sum([candidateImage[k]["value"] for k in range(circlesNum)]) #计算总金额

        number = 0
        img=self.image.copy()
        
        for i in circles[:]:
            cv2.circle(img, (i[0], i[1]), i[2], (0, 0, 255), 2)
            textValue = "{}"
            cv2.putText(img,textValue.format(candidateImage[number]["value"],"%.2f"),(i[0], i[1]+i[2]+25),cv2.FONT_HERSHEY_COMPLEX, 1.0, (0,0,255), 2)
            number = number + 1

     
        text = "The total value of coins is:{:.2f}yuan"
        text=text.format(cionsValue)
        cv2.putText(img, text.format(number), (20, 40), cv2.FONT_HERSHEY_SIMPLEX, 1.0, (100, 200, 200), 2)   
        self.label2.setText(text)
        self.display_image(img)  # 更新显示识别后的图像        