import cv2

bgr_image = cv2.imread("Example3-3.png")
# 把图片从BGR色彩空间转换到BGRA色彩空间
bgra_image = cv2.cvtColor(bgr_image, cv2.COLOR_BGR2BGRA)
cv2.imshow("BGRA", bgr_image) # 显示BGRA图像
b, g, r, a = cv2.split(bgra_image) # 拆分BGRA图像中的通道
a[:, :] = 170 # 将BGRA图像的透明度调整为170（半透明）
bgra_170 = cv2.merge([b, g, r, a]) # 合并拆分后并将透明度调整为170的通道图像
a[:, :] = 0 # 将BGRA图像的透明度调整为0（透明）
bgra_0 = cv2.merge([b, g, r, a]) # 合并拆分后并将透明度调整为0的通道图像
cv2.imshow("A = 170", bgra_170) # 显示透明度为170的BGRA图像
cv2.imshow("A = 0", bgra_0) # 显示透明度为0的BGRA图像
cv2.waitKey()
cv2.destroyAllWindows()