# ui.py
from PyQt5.QtWidgets import QLabel, QVBoxLayout, QWidget, QSlider, QLineEdit, QPushButton, QHBoxLayout
from PyQt5.QtCore import Qt


class ImageBrowserUI(object):
    def setupUi(self, MainWindow):
        MainWindow.setObjectName("MainWindow")
        MainWindow.resize(400, 300)
        self.centralwidget = QWidget(MainWindow)

        self.setWindowTitle('Image Browser')  # 窗口标题
        self.setGeometry(100, 100, 800, 600)  # 设置窗口默认大小

        self.main_layout = QVBoxLayout()  # 窗口总体布局，垂直布局

        self.image_layout = QHBoxLayout()  # image_widget布局，水平布局

        self.image_label = QLabel(self)  # 图像显示控件
        self.image_label.setAlignment(Qt.AlignCenter)
        # 设置 QLabel 的最大尺寸，避免窗口随图像大小变化
        #self.image_label.setMaximumSize(800, 600)
        self.image_layout.addWidget(self.image_label)

        self.zoom_slider = QSlider(Qt.Vertical, self)  # 图像缩放滚动条，垂直滚动条
        self.zoom_slider.setMinimum(10)
        self.zoom_slider.setMaximum(300)
        self.zoom_slider.setValue(100)
        self.zoom_slider.setTickPosition(QSlider.TicksBelow)
        self.zoom_slider.setTickInterval(10)
        self.zoom_slider.setSingleStep(10)

        self.image_layout.addWidget(self.zoom_slider)

        self.controls_layout = QHBoxLayout()  # control_widget布局，水平布局

        self.open_button = QPushButton('打开', self)  # 打开按钮
        self.controls_layout.addWidget(self.open_button)

        self.save_button = QPushButton('保存', self)  # 保存按钮
        self.controls_layout.addWidget(self.save_button)

        self.rotate_edit = QLineEdit('旋转角度', self)  # 旋转角度输入框
        self.controls_layout.addWidget(self.rotate_edit)

        self.rotate_button = QPushButton('旋转', self)  # 旋转按钮
        self.controls_layout.addWidget(self.rotate_button)

        self.shear_edit = QLineEdit('错切角度', self)  # 错切角度输入框
        self.controls_layout.addWidget(self.shear_edit)

        self.shear_button = QPushButton('错切', self)  #
        self.controls_layout.addWidget(self.shear_button)

        self.image_widget = QWidget()
        self.image_widget.setLayout(self.image_layout)  # 设置image_widget布局

        self.control_widget = QWidget()
        self.control_widget.setLayout(self.controls_layout)  # 设置control_widget布局

        self.main_layout.addWidget(self.image_widget)
        self.main_layout.addWidget(self.control_widget)

        self.container = QWidget()
        self.container.setLayout(self.main_layout)
        self.setCentralWidget(self.container)
